      MODULE GWFFHBMODULE
        INTEGER, SAVE, POINTER ::NBDTIM,NFLW,NHED,IFHBCB,NFHBX1,
     1                           NFHBX2,IFHBSS,ISFHBOPT
        INTEGER, SAVE, ALLOCATABLE, DIMENSION(:,:)  ::IFLLOC
        INTEGER, SAVE, ALLOCATABLE, DIMENSION(:,:)  ::IHDLOC
        REAL,    SAVE, ALLOCATABLE, DIMENSION(:)    ::BDTIM
        REAL,    SAVE, ALLOCATABLE, DIMENSION(:,:)  ::FLWRAT
        REAL,    SAVE, ALLOCATABLE, DIMENSION(:,:)  ::SBHED
        REAL,    SAVE, ALLOCATABLE, DIMENSION(:,:)  ::BDFV
        REAL,    SAVE, ALLOCATABLE, DIMENSION(:,:)  ::BDHV
        REAL,    SAVE, ALLOCATABLE, DIMENSION(:)  ::FHBXWT
        DOUBLE PRECISION, SAVE, POINTER :: TIMFHB
        CHARACTER(LEN=16), SAVE, ALLOCATABLE, DIMENSION(:) ::FHBXNM
      END MODULE
CC
C
      SUBROUTINE GWF2FHB7U1AR(IN)
C     ******************************************************************
C     ALLOCATE ARRAY STORAGE AND READ DATA FOR FLOW AND HEAD BOUNDARY
C     PACKAGE
C     ******************************************************************
C
C        SPECIFICATIONS:
C     ------------------------------------------------------------------
      USE GLOBAL,      ONLY:IOUT,ITRSS,IBOUND,IUNSTR,NROW,NCOL
      USE GWFFHBMODULE,ONLY:NBDTIM,NFLW,NHED,IFHBCB,NFHBX1,NFHBX2,
     1                      IFHBSS,IFLLOC,IHDLOC,BDTIM,FLWRAT,SBHED,
     2                      BDFV,BDHV,FHBXWT,FHBXNM,ISFHBOPT,TIMFHB
C
      CHARACTER*400 LINE
      CHARACTER*1 DSH1
      DATA DSH1/'-'/
C     ------------------------------------------------------------------
      ALLOCATE(NBDTIM,NFLW,NHED,IFHBCB,NFHBX1,NFHBX2,IFHBSS,ISFHBOPT)
      ALLOCATE(FHBXWT(10))
      ALLOCATE(FHBXNM(10))
C
C1------IDENTIFY PACKAGE
      WRITE(IOUT,1)IN
    1 FORMAT(1X,/1X,'FHB1 -- SPECIFIED FLOW PACKAGE, VERSION 1,12/3/96',
     &' INPUT READ FROM',I3)
C
C2------READ NUMBER OF TIMES, NUMBER OF SPECIFIED-FLOW CELLS AND
C2------UNIT OR FLAG FOR CELL-BY-CELL FLOW TERMS, NUMBER OF
C2------AUXILIARY VARIABLES, AND OPTIONS.
      CALL URDCOM(IN,IOUT,LINE)
      LLOC=1
      CALL URWORD(LINE,LLOC,ISTART,ISTOP,2,NBDTIM,R,IOUT,IN)
      CALL URWORD(LINE,LLOC,ISTART,ISTOP,2,NFLW,R,IOUT,IN)
      CALL URWORD(LINE,LLOC,ISTART,ISTOP,2,NHED,R,IOUT,IN)
      CALL URWORD(LINE,LLOC,ISTART,ISTOP,2,IFHBSS,R,IOUT,IN)
      CALL URWORD(LINE,LLOC,ISTART,ISTOP,2,IFHBCB,R,IOUT,IN)
      CALL URWORD(LINE,LLOC,ISTART,ISTOP,2,NFHBX1,R,IOUT,IN)
      CALL URWORD(LINE,LLOC,ISTART,ISTOP,2,NFHBX2,R,IOUT,IN)
C      READ(IN,*) NBDTIM,NFLW,NHED,IFHBSS,IFHBCB,NFHBX1,NFHBX2
C
C3-------READ OPTIONS
C3B------READ KEYWORD OPTIONS PONDELEV AND RTS.
      ALLOCATE(ISFHBOPT)
      ISFHBOPT=0
      LLOC=1
81    CALL URWORD(LINE,LLOC,ISTART,ISTOP,1,N,R,IOUT,IN)
C3B1------FOR STAIRCASING INSTEAD OF INTERPOLATING BETWEEN DATA POINTS      
      IF(LINE(ISTART:ISTOP).EQ.'STAIRCASE') THEN
        WRITE(IOUT,13)
   13   FORMAT(1X,'STAIRCASING WILL BE USED INSTEAD OF INTERPOLATION',
     1      '  BETWEEN DATA POINTS - OPTION STAIRCASE IS ON')
        ISFHBOPT = 1
        ALLOCATE(TIMFHB)
        TIMFHB=0
      END IF
      IF(LLOC.LT.200) GO TO 81 
C
C3------PRINT NBDTIM, STOP IF NO TIMES ARE TO BE SPECIFIED
      IF(NFLW.LT.1.AND.NHED.LT.1) THEN
         WRITE(IOUT,4)
 4       FORMAT(1X,'SPECIFIED FLOW AND HEAD BOUNDARY OPTION ',
     &   'CANCELLED.',/,1X,'NO BOUNDARY CELLS WERE SPECIFIED.')
         IN=0
         RETURN
      ENDIF
      IF(NBDTIM.LT.1) THEN
         WRITE(IOUT,6)
 6       FORMAT(1X, 'SIMULATION ABORTING.  NOT ENOUGH TIMES ',
     &   'SPECIFIED FOR FHB1 PACKAGE.')
         CALL USTOP(' ')
      ELSE IF(NBDTIM.EQ.1) THEN
         WRITE(IOUT,8)
 8       FORMAT(1X,' SPECIFIED FLOW AND HEAD VALUES WILL REMAIN ',
     &   'CONSTANT FOR ENTIRE SIMULATION.')
      ELSE
         WRITE(IOUT,10) NBDTIM
 10      FORMAT(1H ,'TOTAL OF',I5,' TIMES WILL BE USED TO DEFINE ',
     &   'VARIATIONS IN FLOW AND HEAD.')
      ENDIF
C
C4------PRINT NFLW AND NHED AND STEADY-STATE OPTION
CERB  This section was changed to use ITRSS instead of ISS
CERB  I also eliminated use of Hollerith constants -- ERB 10/8/2002
      WRITE(IOUT,12) NFLW
 12   FORMAT(1X,'FLOW WILL BE SPECIFIED AT A TOTAL OF',I5,' CELLS.')
      WRITE(IOUT,14) NHED
 14   FORMAT(1X,'HEAD WILL BE SPECIFIED AT A TOTAL OF',I5,' CELLS.')
      IF(ITRSS.NE.0) THEN
        WRITE(IOUT,15)
 15     FORMAT(1X,'FHB STEADY-STATE OPTION FLAG WILL BE IGNORED,'/,
     &          1X,'AT LEAST ONE STRESS PERIOD IS TRANSIENT.')
      ELSE
        IF(IFHBSS.EQ.0) THEN
          WRITE(IOUT,16)
 16       FORMAT(1X,'FLOW, HEAD, AND AUX VARIABLES AT TIME=0 WILL BE ',
     &        /,1X,'USED IN STEADY-STATE SIMULATIONS.')
        ELSE
          WRITE(IOUT,18)
 18       FORMAT(1X,'FLOW, HEAD, AND AUX VARIABLES WILL BE ',
     &      'INTERPOLATED',/,1X,'IN SIMULATIONS.')
        ENDIF
      ENDIF
CERB  End of changed section
C
C5------IF CELL-BY-CELL FLOW TERMS ARE TO BE SAVED THEN PRINT UNIT #
      IF(IFHBCB.GT.0) WRITE(IOUT,20) IFHBCB
 20   FORMAT(1X,'CELL-BY-CELL FLOWS WILL BE RECORDED ON UNIT',I3)
      IF(IFHBCB.LT.0) WRITE(IOUT,24)
 24   FORMAT(1X,'CELL-BY-CELL FLOWS WILL BE PRINTED WHEN ICBCFL NOT 0')
C
C6------READ AUXILIARY VARIABLES
      IF(NFHBX1.GT.5.OR.NFHBX2.GT.5) THEN
         WRITE(IOUT,*) ' ABORTING. A MAXIMUM OF 5 AUXILIARY VARIABLES',
     &   ' CAN BE DEFINED BY FHB.'
         CALL USTOP(' ')
      ENDIF
      WRITE(IOUT,26) NFHBX1
 26   FORMAT(1X,I2,' AUXILIARY VARIABLES FOR SPECIFIED-FLOW CELLS WILL',
     & /,'  BE DEFINED BY FHB FOR USE BY OTHER PACKAGES.')
      IF(NFHBX1.LT.1) GO TO 38
      WRITE(IOUT,28)
 28   FORMAT('       NAME      WEIGHTING FACTOR',/,1X,32('-'))
      DO 30 NX=1,NFHBX1
      READ(IN,'(A)') LINE
      LLOC=1
      CALL URWORD(LINE,LLOC,ISTART,ISTOP,1,N,R,IOUT,IN)
      FHBXNM(NX)=LINE(ISTART:ISTOP)
      CALL URWORD(LINE,LLOC,ISTART,ISTOP,3,N,FHBXWT(NX),IOUT,IN)
      WRITE(IOUT,29) FHBXNM(NX),FHBXWT(NX)
 29   FORMAT(1X,A16,F11.2)
      IF(FHBXWT(NX).LT.0.0.OR.FHBXWT(NX).GT.1.0) THEN
      WRITE(IOUT,*) ' Aborting. Weights for Auxiliary variables cannot'
      WRITE(IOUT,*) ' be less than 0.0 or greater than 1.0.'
      CALL USTOP(' ')
      ENDIF
 30   CONTINUE
 38   WRITE(IOUT,126) NFHBX2
 126  FORMAT(1X,I2,' AUXILIARY VARIABLES FOR SPECIFIED-HEAD CELLS WILL',
     & /,'  BE DEFINED BY FHB FOR USE BY OTHER PACKAGES.')
      IF(NFHBX2.LT.1) GO TO 200
      WRITE(IOUT,28)
      DO 130 NX=1,NFHBX2
      READ(IN,'(A)') LINE
      LLOC=1
      CALL URWORD(LINE,LLOC,ISTART,ISTOP,1,N,R,IOUT,IN)
      FHBXNM(5+NX)=LINE(ISTART:ISTOP)
      CALL URWORD(LINE,LLOC,ISTART,ISTOP,3,N,FHBXWT(5+NX),IOUT,IN)
      WRITE(IOUT,129) FHBXNM(5+NX),FHBXWT(5+NX)
 129  FORMAT(1X,A16,F11.2)
      IF(FHBXWT(5+NX).LT.0.0.OR.FHBXWT(5+NX).GT.1.0) THEN
      WRITE(IOUT,*) ' Aborting. Weights for Auxiliary variables cannot'
      WRITE(IOUT,*) ' be less than 0.0 or greater than 1.0.'
      CALL USTOP(' ')
      ENDIF
 130  CONTINUE
C7------ALLOCATE SPACE FOR ARRAYS BDTIM, IFLLOC, FLWRAT, BDFV,
C7------IHDLOC, SBHED, AND BDHV
 200  IFHBD3=NBDTIM*(1+NFHBX1)
      IFHBD4=2+NFHBX1
      IFHBD5=NBDTIM*(1+NFHBX2)
      IF(NFLW.GT.0) THEN
         ALLOCATE(FLWRAT(IFHBD3,NFLW))
         ALLOCATE(BDFV(IFHBD4,NFLW))
         ALLOCATE(IFLLOC(4,NFLW))
      ELSE
         ALLOCATE(FLWRAT(1,1))
         ALLOCATE(BDFV(1,1))
         ALLOCATE(IFLLOC(1,1))
      END IF
      IF(NHED.GT.0) THEN
         ALLOCATE(SBHED(IFHBD5,NHED))
         ALLOCATE(BDHV(NFHBX2,NHED))
         ALLOCATE(IHDLOC(4,NHED))
      ELSE
         ALLOCATE(SBHED(1,1))
         ALLOCATE(BDHV(1,1))
         ALLOCATE(IHDLOC(1,1))
      END IF
      ALLOCATE(BDTIM(NBDTIM))
C
C1------READ TIMES AT WHICH SPECIFIED FLOW AND HEAD VALUES WILL BE READ
      READ(IN,*) IFHBUN,CNSTM,IFHBPT
      WRITE(IOUT,310) IFHBUN,CNSTM
310   FORMAT(1X,'TIMES FOR SPECIFIED-FLOW AND HEAD VALUES WILL BE READ',
     & ' ON UNIT',I4,' AND',/,
     &' MULTIPLIED BY',G12.4,'.')
      READ(IFHBUN,*) (BDTIM(L),L=1,NBDTIM)
      DO 312 L=1,NBDTIM
      BDTIM(L)=BDTIM(L)*CNSTM
312   CONTINUE
C
C2------IF DESIRED, PRINT TABLE OF TIMES
      IF(IFHBPT.GT.0) THEN
         WRITE(IOUT,320) NBDTIM
320      FORMAT(1X,I5,' TIMES FOR SPECIFYING FLOWS AND HEADS:')
         WRITE(IOUT,322) (L,L=1,NBDTIM)
322      FORMAT(16X,I8,4I12)
         ND=MIN0(60,NBDTIM*12)
         WRITE(IOUT,324) (DSH1,M=1,ND)
324      FORMAT(17X,60A1)
         WRITE(IOUT,326) (BDTIM(L),L=1,NBDTIM)
326      FORMAT(17X,5G12.4)
      ENDIF
C
C3------MAKE SURE THAT FIRST TIME IS ZERO AND THAT TIMES INCREASE
      ICHK1=0
      ICHK2=0
      IF(BDTIM(1).NE.0.0) THEN
         WRITE(IOUT,330)
330      FORMAT(1X,'STARTING TIME FOR SPECIFIED FLOWS AND HEADS MUST',
     &   ' BE ZERO. ABORTING.')
         ICHK1=1
      ENDIF
      DO 40 L=2,NBDTIM
      IF(BDTIM(L).LT.BDTIM(L-1)) THEN
         WRITE(IOUT,32)
 32      FORMAT(1X,'TIMES FOR SPECIFIED FLOWS MUST INCREASE.',
     &   '  ABORTING.')
         ICHK2=1
         GO TO 42
      ENDIF
 40   CONTINUE
 42   IF(ICHK1.EQ.1.OR.ICHK2.EQ.1) CALL USTOP(' ')
C
C4A-----READ CELL INDICIES AND SPECIFIED-FLOW RATES
      IF(NFLW.LT.1) GO TO 70
      READ(IN,*) IFHBUN,CNSTM,IFHBPT
      WRITE(IOUT,50) IFHBUN,CNSTM
 50   FORMAT(/,1X,'CELL INDICIES AND SPECIFIED-FLOW RATES ',
     & 'WILL BE READ ON UNIT',I4,'. RATES WILL',/,
     & 1X,'BE MULTIPLIED BY',G12.4,'.')
      IF(IFHBPT.GT.0) THEN
         IF(IUNSTR.EQ.0)THEN
           WRITE(IOUT,52)
 52      FORMAT(1X,'LAYER  ROW  COL IAUX              FLOW RATES')
         ELSE
           WRITE(IOUT,53)
 53      FORMAT(1X,'     NODE   IAUX              FLOW RATES')
         ENDIF
         ND=MIN0(79,19+NBDTIM*12)
         WRITE(IOUT,54) (DSH1,M=1,ND)
 54      FORMAT(1X,78A1)
      ENDIF
      DO 59 N=1,NFLW
       IF(IUNSTR.EQ.0)THEN
        READ(IFHBUN,*) (IFLLOC(I,N),I=1,4),(FLWRAT(L,N),L=1,NBDTIM)
        IL = IFLLOC(1,N)
        IR = IFLLOC(2,N)
        IC = IFLLOC(3,N)
        ND = IC + NCOL*(IR-1) + (IL-1)* NROW*NCOL
        IFLLOC(1,N) = ND
      ELSE
        READ(IFHBUN,*) IFLLOC(1,N),IFLLOC(4,N),(FLWRAT(L,N),L=1,NBDTIM)
      ENDIF
      DO 56 L=1,NBDTIM
      FLWRAT(L,N)=FLWRAT(L,N)*CNSTM
 56   CONTINUE
C
C4B-----IF DESIRED, PRINT TABLE OF SPECIFIED-FLOW CELL LOCATIONS
C4B-----AND RATES
      IF(IFHBPT.GT.0) THEN
         IF(IUNSTR.EQ.0)WRITE(IOUT,58)
     *     (IFLLOC(I,N),I=1,4),(FLWRAT(L,N),L=1,NBDTIM)
 58      FORMAT(1X,I4,3I5,5G12.4,/,(20X,5G12.4))
          IF(IUNSTR.NE.0)WRITE(IOUT,158)
     *     IFLLOC(1,N),IFLLOC(4,N),(FLWRAT(L,N),L=1,NBDTIM)
 158      FORMAT(1X,I9,I5,10G15.6,/,(15X,10G15.6))
      ENDIF
 59   CONTINUE
C
C5A------READ VALUES OF AUXILIARY VARIABLES FOR SPECIFIED-FLOW CELLS
      IF(NFHBX1.LT.1) GO TO 70
      DO 69 NX=1,NFHBX1
      NS=NBDTIM*NX
      READ(IN,*) IFHBUN,CNSTM,IFHBPT
      WRITE(IOUT,61) FHBXNM(NX),IFHBUN,CNSTM
 61   FORMAT(/,1X,A16,
     & 'FOR SPECIFIED-FLOW CELLS WILL BE READ ON UNIT',I4,'.',/,
     &  ' VALUES WILL BE MULTIPLIED BY',G12.4,'.')
      IF(IFHBPT.GT.0) THEN
         WRITE(IOUT,62) FHBXNM(NX)
 62      FORMAT(1X,'LAYER  ROW  COL IAUX  ',A16)
         WRITE(IOUT,54) (DSH1,M=1,ND)
      ENDIF
      DO 68 N=1,NFLW
      READ(IFHBUN,*) (FLWRAT(NS+L,N),L=1,NBDTIM)
      DO 66 L=1,NBDTIM
      FLWRAT(NS+L,N)=FLWRAT(NS+L,N)*CNSTM
 66   CONTINUE
C
C5B------IF DESIRED, PRINT TABLE OF AUXILIARY VARIABLE VALUES AT
C5B------SPECIFIED-FLOW CELL LOCATIONS
      IF(IFHBPT.GT.0) THEN
         WRITE(IOUT,58) (IFLLOC(I,N),I=1,4),
     &                        (FLWRAT(NS+L,N),L=1,NBDTIM)
 67      FORMAT(1X,I4,2I6,5G12.4,/,(17X,5G12.4))
      ENDIF
 68   CONTINUE
 69   CONTINUE
C
C6------READ CELL INDICIES AND SPECIFIED-HEAD VALUES
 70   IF(NHED.LT.1) GO TO 300
      READ(IN,*) IFHBUN,CNSTM,IFHBPT
      WRITE(IOUT,71) IFHBUN,CNSTM
 71   FORMAT(/,1X,'CELL INDICIES AND SPECIFIED-HEAD VALUES ',
     & 'WILL BE READ ON UNIT',I4,'. HEAD VALUES',/,
     & 1X,'WILL BE MULTIPLIED BY',G12.4,'.')
      IF(IFHBPT.GT.0) THEN
         IF(IUNSTR.EQ.0) WRITE(IOUT,72)
 72      FORMAT(1X,'LAYER  ROW  COL IAUX             HEAD VALUES')
         IF(IUNSTR.NE.0) WRITE(IOUT,272)
 272     FORMAT(1X,'     NODE IAUX             HEAD VALUES')
         ND=MIN0(79,19+NBDTIM*12)
         WRITE(IOUT,74) (DSH1,M=1,ND)
 74      FORMAT(1X,79A1)
      ENDIF
      DO 80 N=1,NHED
      IF(IUNSTR.EQ.0)THEN
        READ(IFHBUN,*) (IHDLOC(I,N),I=1,4),(SBHED(L,N),L=1,NBDTIM)
        IL = IHDLOC(1,N)
        IR = IHDLOC(2,N)
        IC = IHDLOC(3,N)
        ND = IC + NCOL*(IR-1) + (IL-1)* NROW*NCOL
        IHDLOC(1,N) = ND
      ELSE
        READ(IFHBUN,*) IHDLOC(1,N),IHDLOC(4,N),(SBHED(L,N),L=1,NBDTIM)
      ENDIF
      DO 75 L=1,NBDTIM
      SBHED(L,N)=SBHED(L,N)*CNSTM
 75   CONTINUE
C
C7------AT SPECIFIED-HEAD LOCATIONS, SET IBOUND TO NEGATIVE NUMBER.
C7------IGNORE SPECIFIED-HEAD CONDITIONS AT CELLS WHERE IBOUND IS ZERO
      ND=IHDLOC(1,N)
      IF(IBOUND(ND).NE.0) THEN
         IBOUND(ND)=-IABS(IBOUND(ND))
      ELSE
        IF(IUNSTR.EQ.0)THEN
           WRITE(IOUT,76) IR,IC,IL
 76       FORMAT(1X,'SPECIFIED-HEAD VALUE IGNORED AT ROW',I5,', COLUMN',
     &    I5,', AND LAYER',I5,'.')
        ELSE
           WRITE(IOUT,77) IHDLOC(1,N)
77       FORMAT(1X,'SPECIFIED-HEAD VALUE IGNORED AT NODE',I5,'.')
        ENDIF
      ENDIF
C
C8------IF DESIRED, PRINT TABLE OF SPECIFIED-FLOW CELL LOCATIONS
C8------AND RATES
      IF(IFHBPT.GT.0) THEN
       IF(IBOUND(ND).NE.0)THEN
         IF(IUNSTR.EQ.0)
     &  WRITE(IOUT,58) IL,IR,IC,IHDLOC(4,N),(SBHED(L,N),L=1,NBDTIM)
         IF(IUNSTR.NE.0)
     &  WRITE(IOUT,158)IHDLOC(1,N),IHDLOC(4,N),(SBHED(L,N),L=1,NBDTIM)
       ENDIF
      ENDIF
 80   CONTINUE
C
C9A------READ VALUES OF AUXILIARY VARIABLES FOR SPECIFIED-HEAD CELLS
      IF(NFHBX2.LT.1) GO TO 300
      DO 169 NX=1,NFHBX2
      NS=NBDTIM*NX
      READ(IN,*) IFHBUN,CNSTM,IFHBPT
      WRITE(IOUT,161) FHBXNM(5+NX),IFHBUN,CNSTM
 161  FORMAT(/,1X,A16,
     & 'FOR SPECIFIED-HEAD CELLS WILL BE READ ON UNIT',I4,'.',/,
     &  ' VALUES WILL BE MULTIPLIED BY',G12.4,'.')
      IF(IFHBPT.GT.0) THEN
         WRITE(IOUT,62) FHBXNM(5+NX)
         WRITE(IOUT,54) (DSH1,M=1,ND)
      ENDIF
      DO 168 N=1,NHED
      READ(IFHBUN,*) (SBHED(NS+L,N),L=1,NBDTIM)
      DO 166 L=1,NBDTIM
      SBHED(NS+L,N)=SBHED(NS+L,N)*CNSTM
 166  CONTINUE
C
C9B------IF DESIRED, PRINT TABLE OF AUXILIARY VARIABLE VALUES AT
C9B------SPECIFIED-HEAD CELL LOCATIONS
      IF(IFHBPT.GT.0) THEN
       IF(IUNSTR.EQ.0)  WRITE(IOUT,58) (IHDLOC(I,N),I=1,4),
     &                        (SBHED(NS+L,N),L=1,NBDTIM)
       IF(IUNSTR.NE.0)  WRITE(IOUT,158) IHDLOC(1,N),IHDLOC(4,N),
     &                        (SBHED(NS+L,N),L=1,NBDTIM)
      ENDIF
 168  CONTINUE
 169  CONTINUE
C
C10-----RETURN
 300  CONTINUE
      RETURN
      END
      SUBROUTINE GWF2FHB7AD
C     ******************************************************************
C     COMPUTE SPECIFIED FLOWS AND HEADS AT CURRENT TIME STEP
C     ******************************************************************
C
C        SPECIFICATIONS:
C     ------------------------------------------------------------------
      USE GLOBAL,      ONLY:ITRSS,HNEW,HOLD
      USE GWFBASMODULE,ONLY:DELT,TOTIM,TMINAT
      USE GWFFHBMODULE,ONLY:NBDTIM,NFLW,NHED,IFHBCB,NFHBX1,NFHBX2,
     1                      IFHBSS,IFLLOC,IHDLOC,BDTIM,FLWRAT,SBHED,
     2                      BDFV,BDHV,FHBXWT,ISFHBOPT,TIMFHB
      DOUBLE PRECISION T1,T2,TP,DDT,QFACT1,QFACT2
C     ------------------------------------------------------------------
C
C1------IF THIS IS A STEADY-STATE SIMULATION OR A TRANSIENT SIMULATION
C1------WITH CONSTANT SPECIFIED FLOWS AND HEADS, SET VALUES AND RETURN
      IF((ITRSS.EQ.0.AND.IFHBSS.EQ.0).OR.NBDTIM.EQ.1) THEN
         IF(NFLW.LT.1) GO TO 6
         DO 5 NF=1,NFLW
         BDFV(1,NF)=FLWRAT(1,NF)
         IF(NFHBX1.LT.1) GO TO 5
         DO 4 NX=1,NFHBX1
         N1=2+NX
         N2=1+NX*NBDTIM
         BDFV(N1,NF)=FLWRAT(N2,NF)
 4       CONTINUE
 5       CONTINUE
 6       IF(NHED.LT.1) RETURN
         DO 10 NH=1,NHED
         ND=IHDLOC(1,NH)
         HNEW(ND)=SBHED(1,NH)
         HOLD(ND)=SBHED(1,NH)
         IF(NFHBX2.LT.1) GO TO 10
         DO 8 NX=1,NFHBX2
         N2=1+NX*NBDTIM
         BDHV(NX,NH)=SBHED(N2,NH)
 8       CONTINUE
 10      CONTINUE
         RETURN
      ENDIF
C
C2------FIND ARRAY INDICES OF TIMES AROUND TIME AT START OF CURRENT
C2------TIME STEP
      IB4=0
      IF(NFLW.LT.1) GO TO 200
      T2=TOTIM
      T1=TOTIM-DELT
      DO 20 L=2,NBDTIM
      IF(T1.LE.BDTIM(L)) THEN
         IB1=L-1
         IB2=L
         GO TO 40
      ENDIF
 20   CONTINUE
      IB1=NBDTIM-1
      IB2=NBDTIM
C
C3------COMPUTE FACTOR FOR INTERPOLATION OR EXTRAPOLATION OF FLOW AT
C3------START OF CURRENT TIME STEP
 40   QFACT1=(T1-BDTIM(IB1))/(BDTIM(IB2)-BDTIM(IB1))
      IF(ISFHBOPT.EQ.1) QFACT1 = 0.
C
C4------FIND ARRAY INDICES OF TIMES AROUND TIME AT END OF CURRENT
C4------TIME STEP
      DO 60 L=IB2,NBDTIM
      IF(T2.LE.BDTIM(L)) THEN
         IB3=L-1
         IB4=L
         GO TO 70
      ENDIF
 60   CONTINUE
      IB4=NBDTIM
      IB3=NBDTIM-1
C
C5------COMPUTE FACTOR FOR INTERPOLATION OR EXTRAPOLATION OF FLOW AT
C5------END OF CURRENT TIME STEP
 70   QFACT2=(T2-BDTIM(IB3))/(BDTIM(IB4)-BDTIM(IB3))
      IF(ISFHBOPT.EQ.1) QFACT2 = 0.
C
C6------COMPUTE SPECIFIED FLOW RATES FOR THIS TIME STEP
      NPI=IB4-IB2
      DO 90 NF=1,NFLW
      QA=FLWRAT(IB1,NF)
      QB=FLWRAT(IB2,NF)
      QC=FLWRAT(IB3,NF)
      QD=FLWRAT(IB4,NF)
      Q1=(QA+QFACT1*(QB-QA))
      Q2=(QC+QFACT2*(QD-QC))
      IF(NPI.EQ.0) THEN
         BDFV(1,NF)=0.5*(Q1+Q2)
      ELSE
         TP=T1
         QP=Q1
         SUM1=0.0
         DO 80 NI=IB2,IB3
         QN=FLWRAT(NI,NF)
         DDT=BDTIM(NI)-TP
         SUM1=SUM1+DDT*0.5*(QN+QP)
         TP=BDTIM(NI)
         QP=QN
 80      CONTINUE
         DDT=T2-TP
         SUM1=SUM1+DDT*0.5*(Q2+QP)
         BDFV(1,NF)=SUM1/DELT
      ENDIF
 90   CONTINUE
C
C7-----COMPUTE VALUES OF AUXILIARY VARIABLES FOR SPECIFIED-FLOW
C7-----CELLS FOR CURRENT TIME STEP
      IF(NFHBX1.LT.1) GO TO 200
      DO 190 NX=1,NFHBX1
      N1=2+NX
      N2=NX*NBDTIM
      TT=TOTIM-(1.-FHBXWT(NX))*DELT
      DO 120 L=2,NBDTIM
      IF(TT.LE.BDTIM(L)) THEN
         IB1=L-1
         IB2=L
         GO TO 140
      ENDIF
 120  CONTINUE
      IB1=NBDTIM-1
      IB2=NBDTIM
 140  XFACT=(TT-BDTIM(IB1))/(BDTIM(IB2)-BDTIM(IB1))
      IF(ISFHBOPT.EQ.1) XFACT = 0.
      DO 150 NF=1,NFLW
      XX=FLWRAT(N2+IB1,NF)+XFACT*(FLWRAT(N2+IB2,NF)-FLWRAT(N2+IB1,NF))
      BDFV(N1,NF)=XX
 150  CONTINUE
 190  CONTINUE
C8------FIND ARRAY INDICES OF TIMES AROUND TIME AT END OF CURRENT
C8------TIME STEP, COMPUTE FACTOR OF INTERPOLATION OR EXTRAPOLATION
C8------OF HEAD
 200  IF(NHED.LT.1) GO TO 201
      TT=TOTIM
      DO 220 L=2,NBDTIM
      IF(TT.LE.BDTIM(L)) THEN
         IB1=L-1
         IB2=L
         GO TO 240
      ENDIF
 220  CONTINUE
      IB1=NBDTIM-1
      IB2=NBDTIM
 240  HFACT=(TT-BDTIM(IB1))/(BDTIM(IB2)-BDTIM(IB1))
      IF(ISFHBOPT.EQ.1) HFACT = 0.
C
C9------AT EACH SPECIFIED-HEAD LOCATION, INTERPOLATE OR EXTRAPOLATE
C9------HEAD. SET HNEW AND HOLD EQUAL TO COMPUTED HEAD
      DO 250 NH=1,NHED
      ND=IHDLOC(1,NH)
      HH=SBHED(IB1,NH)+HFACT*(SBHED(IB2,NH)-SBHED(IB1,NH))
      HNEW(ND)=HH
      HOLD(ND)=HH
 250  CONTINUE
C
C10----COMPUTE VALUES OF AUXILIARY VARIABLES FOR FOR SPECIFIED-HEAD
C10----CELLS FOR CURRENT TIME STEP
      IF(NFHBX2.LT.1) GO TO 201
      DO 390 NX=1,NFHBX2
      N2=NX*NBDTIM
      TT=TOTIM-(1.-FHBXWT(5+NX))*DELT
      DO 320 L=2,NBDTIM
      IF(TT.LE.BDTIM(L)) THEN
         IB1=L-1
         IB2=L
         GO TO 340
      ENDIF
 320  CONTINUE
      IB1=NBDTIM-1
      IB2=NBDTIM
 340  XFACT=(TT-BDTIM(IB1))/(BDTIM(IB2)-BDTIM(IB1))
      IF(ISFHBOPT.EQ.1) XFACT = 0.
      DO 350 NF=1,NHED
      XX=SBHED(N2+IB1,NF)+XFACT*(SBHED(N2+IB2,NF)-SBHED(N2+IB1,NF))
      BDHV(NX,NF)=XX
 350  CONTINUE
 390  CONTINUE
201   CONTINUE
C11-----FILL TIMFHB FOR ATS
      IF(ISFHBOPT.EQ.1) THEN
        IF(IB4.GT.0) TIMFHB = BDTIM(IB4)
C11B------ADVANCE TIMFHB WHEN TIME EXCEEDS PREVIOUS TIMFHB        
        IF(TOTIM.GE.TIMFHB-TMINAT)THEN
          IF(IB4.LT.NBDTIM)THEN
            TIMFHB = BDTIM(IB4+1)
          ELSE
            TIMFHB = 1.0E30
          ENDIF
        ENDIF
      ENDIF
C
C11------RETURN
      RETURN
      END
      SUBROUTINE GWF2FHB7U1FM
C     ******************************************************************
C     SUBTRACT SPECIFIED Q FROM RHS
C     ******************************************************************
C
C        SPECIFICATIONS:
C     ------------------------------------------------------------------
      USE GLOBAL,      ONLY:IBOUND,RHS
      USE GWFFHBMODULE,ONLY:NFLW,IFLLOC,BDFV
C     ------------------------------------------------------------------
C
C1------PROCESS EACH SPECIFIED-FLOW LOCATION IN THE LIST.
      IF(NFLW.LE.0) RETURN
      DO 100 L=1,NFLW
      ND=IFLLOC(1,L)
      Q=BDFV(1,L)
C
C1A-----IF THE CELL IS INACTIVE THEN BYPASS PROCESSING.
      IF(IBOUND(ND).LE.0) GO TO 100
C
C1B-----IF THE CELL IS VARIABLE HEAD THEN SUBTRACT Q FROM
C       THE RHS ACCUMULATOR.
      RHS(ND)=RHS(ND)-Q
  100 CONTINUE
C
C2------RETURN
      RETURN
      END
      SUBROUTINE GWF2FHB7U1BD(KSTP,KPER)
C     ******************************************************************
C     CALCULATE VOLUMETRIC BUDGET FOR SPECIFIED FLOWS
C     ******************************************************************
C
C        SPECIFICATIONS:
C     ------------------------------------------------------------------
      USE GLOBAL, ONLY:IOUT,NCOL,NROW,NLAY,IBOUND,BUFF,IUNSTR,NODES,
     1                 NEQS,FMBE,INCLN
      USE CLN1MODULE,  ONLY:NCLNNDS,ICLNCB 
      USE GWFBASMODULE,ONLY:MSUM,VBVL,VBNM,ICBCFL,DELT,PERTIM,TOTIM
      USE GWFFHBMODULE,ONLY:NBDTIM,NFLW,NHED,IFHBCB,NFHBX1,NFHBX2,
     1                      IFHBSS,IFLLOC,IHDLOC,BDTIM,FLWRAT,SBHED,
     2                      BDFV,BDHV,FHBXWT,FHBXNM
C
      CHARACTER*16 TEXT
      DOUBLE PRECISION RATIN,RATOUT,QQ
C
      DIMENSION XFACE(1)
      DATA TEXT/' SPECIFIED FLOWS'/
C     ------------------------------------------------------------------
C
C1------CLEAR RATIN AND RATOUT ACCUMULATORS.
      ZERO=0.
      RATIN=ZERO
      RATOUT=ZERO
      IBD=0
      IF(IFHBCB.LT.0 .AND. ICBCFL.NE.0) IBD=-1
      IF(IFHBCB.GT.0) IBD=ICBCFL
C
C2A----IF CELL-BY-CELL FLOWS WILL BE SAVED AS A LIST, WRITE HEADER.
      IF(IBD.EQ.2) THEN
        NFHBGW = 0
        NFHBCLN = 0
        DO L=1,NFLW
          N=IFLLOC(1,L)
          IF(N.GT.NODES) THEN
            NFHBCLN = NFHBCLN + 1
          ELSE
            NFHBGW = NFHBGW + 1
          ENDIF
        ENDDO
        IICLNCB=0
        NNCLNNDS=0
        IF(INCLN.GT.0) THEN
          IICLNCB=ICLNCB
          NNCLNNDS=NCLNNDS
        ENDIF
        NAUX=1
        IF(IAUXSV.EQ.0) NAUX=0
        IF(IUNSTR.EQ.0) THEN
          CALL UBDSV4(KSTP,KPER,TEXT,NAUX,'IFACE           ',IFHBCB,
     1          NCOL,NROW,NLAY,NFHBGW,IOUT,DELT,PERTIM,TOTIM,IBOUND)
        ELSE
          CALL UBDSV4U(KSTP,KPER,TEXT,NAUX,'IFACE           ',IFHBCB,
     1          NODES,NFHBGW,IOUT,DELT,PERTIM,TOTIM,IBOUND)
        ENDIF
        IF(INCLN.GT.0) THEN
          IF(ICLNCB.GT.0)
     1      CALL UBDSV4U(KSTP,KPER,TEXT,NAUX,'IFACE           ',IICLNCB,
     2                 NNCLNNDS,NFHBCLN,IOUT,DELT,PERTIM,TOTIM,IBOUND)
        ENDIF
      ENDIF
C
C2B----CLEAR THE BUFFER.
      DO 50 ND=1,NEQS
      BUFF(ND)=ZERO
   50 CONTINUE
C
C3A----IF THERE ARE NO SPECIFIED-FLOW CELLS, DO NOT ACCUMULATE FLOW
      IF(NFLW.EQ.0) GO TO 200
C
C3B-----PROCESS SPECIFIED-FLOW CELLS ONE AT A TIME.
   60 DO 100 L=1,NFLW
C
C3C-----GET LAYER, ROW, AND COLUMN NUMBERS
      ND=IFLLOC(1,L)
      Q=ZERO
C
C3D-----IF THE CELL IS NO-FLOW OR CONSTANT-HEAD, IGNORE IT.
      IF(IBOUND(ND).LE.0)GO TO 97
C
C4A-----GET FLOW RATE FROM SPECIFIED-FLOW LIST
      Q=BDFV(1,L)
      QQ=Q
C
C4B-----PRINT THE INDIVIDUAL RATES IF REQUESTED(IFHBCB<0).
      IF(IBD.LT.0) THEN
        IF(IUNSTR.EQ.0)THEN
        IL = (ND-1) / (NCOL*NROW) + 1
        IJ = ND - (IL-1)*NCOL*NROW
        IR = (IJ-1)/NCOL + 1
        IC = IJ - (IR-1)*NCOL
        WRITE(IOUT,900) TEXT,KPER,KSTP,L,IL,IR,IC,Q
  900   FORMAT(1H0,4A4,'   PERIOD',I3,'   STEP',I3,' SEQ NO',I4,
     1    '   LAYER',I3,'   ROW ',I4,'   COL',I4,'   RATE',G15.7)
        ELSE
          WRITE(IOUT,901) TEXT,KPER,KSTP,L,ND,Q
  901   FORMAT(1H0,4A4,'   PERIOD',I3,'   STEP',I3,' SEQ NO',I4,
     1    '    NODE',I8,'   RATE',G15.7)
        ENDIF
      ENDIF
C
C4C-----ADD FLOW RATE TO BUFFER.
      BUFF(ND)=BUFF(ND)+Q
      FMBE(ND) = FMBE(ND) + Q 
C
C5A-----SEE IF FLOW RATE IS NEGATIVE, ZERO, OR POSITIVE.
      IF(Q.GE.ZERO) THEN
C
C5B-----FLOW RATE IS POSITIVE (RECHARGE). ADD IT TO RATIN.
        RATIN=RATIN+QQ
      ELSE
C
C5C-----FLOW RATE IS NEGATIVE(DISCHARGE). ADD IT TO RATOUT.
        RATOUT=RATOUT-QQ
      END IF
C
C6------IF CELL-BY-CELL FLOWS ARE BEING SAVED AS A LIST, WRITE FLOW.
C6------RETURN THE ACTUAL FLOW IN THE BDFV ARRAY.
   97 CONTINUE
      IF(IBD.EQ.2)THEN
        XFACE(1)=IFLLOC(4,L)
        IF(ND.GT.NODES) THEN
          IF(IICLNCB.GT.0)
     1    CALL UBDSVBU(ICLNCB,NCLNNDS,ND-NODES,Q,XFACE,1,NAUX,
     2                 1,IBOUND)
        ELSE
          IF(IUNSTR.EQ.0)THEN
            IL = (ND-1) / (NCOL*NROW) + 1
            IJ = ND - (IL-1)*NCOL*NROW
            IR = (IJ-1)/NCOL + 1
            IC = IJ - (IR-1)*NCOL
            CALL UBDSVB(IFHBCB,NCOL,NROW,IC,IR,IL,Q,
     1                    XFACE,1,NAUX,1,IBOUND,NLAY)          
          ELSE
            CALL UBDSVBU(IFHBCB,NODES,ND,Q,
     1                    XFACE,1,NAUX,1,IBOUND)          
          ENDIF 
        ENDIF
      ENDIF
      BDFV(2,L)=Q
  100 CONTINUE
C
C7------IF CELL-BY-CELL FLOWS WILL BE SAVED AS A 3-D ARRAY,
C7------CALL UBUDSV TO SAVE THEM
      IF(IBD.EQ.1)THEN
        IF(IUNSTR.EQ.0)THEN
          CALL UBUDSV(KSTP,KPER,TEXT,IFHBCB,BUFF,NCOL,NROW,
     1                          NLAY,IOUT)
        ELSE
          CALL UBUDSVU(KSTP,KPER,TEXT,IFHBCB,BUFF(1),NODES,
     1                          IOUT,PERTIM,TOTIM)
        ENDIF
      ENDIF
      IF(IBD.EQ.1.AND.INCLN.GT.0)THEN
        IF(ICLNCB.GT.0) CALL UBUDSVU(KSTP,KPER,TEXT,ICLNCB,
     1    BUFF(NODES+1),NCLNNDS,IOUT,PERTIM,TOTIM)
      ENDIF
C
C8------MOVE RATES, VOLUMES & LABELS INTO ARRAYS FOR PRINTING.
 200  RIN=RATIN
      ROUT=RATOUT
      VBVL(3,MSUM)=RIN
      VBVL(4,MSUM)=ROUT
      VBVL(1,MSUM)=VBVL(1,MSUM)+RIN*DELT
      VBVL(2,MSUM)=VBVL(2,MSUM)+ROUT*DELT
      VBNM(MSUM)=TEXT
C
C9------INCREMENT BUDGET TERM COUNTER (MSUM).
      MSUM=MSUM+1
C
C10-----RETURN
      RETURN
      END
      SUBROUTINE GWF2FHB7U1DA
C  Deallocate FHB DATA
      USE GWFFHBMODULE
C
        DEALLOCATE(NBDTIM)
        DEALLOCATE(NFLW)
        DEALLOCATE(NHED)
        DEALLOCATE(IFHBCB)
        DEALLOCATE(NFHBX1)
        DEALLOCATE(NFHBX2)
        DEALLOCATE(IFHBSS)
        DEALLOCATE(FHBXWT)
        DEALLOCATE(FHBXNM)
        DEALLOCATE(BDTIM)
        DEALLOCATE(FLWRAT)
        DEALLOCATE(BDFV)
        DEALLOCATE(IFLLOC)
        DEALLOCATE(SBHED)
        DEALLOCATE(BDHV)
        DEALLOCATE(IHDLOC)
        IF(ISFHBOPT.NE.0) THEN 
          DEALLOCATE (TIMFHB)
        ENDIF  
        DEALLOCATE (ISFHBOPT)
C
      RETURN
      END
